unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs,CioinaEvalActivX_TLB,StdCtrls, Buttons,math;

  type
  TForm1 = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Memo1: TMemo;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    CheckBox1: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
    procedure ParseErrorMesssage(Item: Integer);
    procedure ExecuteErrorMesssage(Item: Integer);
    procedure CheckBox1Click(Sender: TObject);
    procedure Edit1Click(Sender: TObject);
    procedure Edit2Click(Sender: TObject);
    procedure Edit3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  EX_NONMATH=0;
  EX_Overflow=1;
  EX_Underflow=2;
  EX_InvalidArgument=3;
  EX_ZeroDivide=4;
  EX_InvalidOp=5;

  ERR_NOERROR=0;
  ERR_NO_MATH_EXPRESSION_WAS_PARSED=-1;
  ERR_PARANTHESES_SYNTAX_ERROR=-2;
  ERR_INVALID_DERIVATIVE_VARIABLE_NAME=-3;
  ERR_MATH_EXPRESSION_IS_EMPTY=-4;
  ERR_IDENTIFIER_CANNOT_BE_EMPTY=-5;
  ERR_IDENTIFIER_LENGTH=-6;
  ERR_NOT_PASCAL_IDENTIFIER=-7;
  ERR_IDENTIFIER_CANNOT_BE_RESERVED_NAME=-8;
  ERR_IDENTIFIER_ALREADY_EXISTS=-9;
  ERR_DUBLICATING_USER_IDENTIFIER=-10;
  ERR_UNKNOWN_EXPRESSION=-11;
  ERR_BAD_EXPONENTIAL_FORMAT=-12;
  ERR_SET_OriginalMathExpressionString_FALSE=-13;
  ERR_MATH_EXPRESSION_WAS_ERASED=-14;
  ERR_USE_VerifySyntaxSemanticsAndDerivation=-15;
  ERR_DERIVATIVE_EXPRESSION_WAS_ERASED=-16;
  ERR_VARIABLES_AND_VALUES_ARE_DIFFERENT=-17;
  ERR_MATH_EXPRESSIONS_ARRAY=-18;
  ERR_FUNCTION_NUMBER_MUST_BE_LESS=-19;
  ERR_FUNCTION_ADDRESS_CANNOT_BE_NIL=-20;
  ERR_PROTECTED_EXPRESSION=-21;
  ERR_PARSE=-22;
  ERR_EXECUTE=-23;
  ERR_DYNAMIC_MEMORY=-24;
  ERR_MULTIPLY=-25;
  ERR_DIVISION=-26;
  ERR_PLUS=-27;
  ERR_MINUS=-28;
  ERR_POWER=-29;
  ERR_EQUAL=-30;
  ERR_UNKNOWN_FUNCTION=-31;
  ERR_UNKNOWN_VARIABLE=-32;
  ERR_BAD_SYNTAX=-33;
  ERR_COMMA_SYNTAX=-34;
  ERR_SYSTEM_STACK_OVERFLOW=-35;
  ERR_DEF_FUNC_NAME=-36;
  ERR_DEF_FUNC_DUBLICATING=-37;
  ERR_DEF_FUNC_IMPLEMENTING=-38;
  ERR_DEF_FUNC_ARG_COUNT=-39;
  ERR_DEF_FUNC_ARG_NAME=-40;
  ERR_DEF_FUNC_ARG_DUBLICATING=-41;
  ERR_DEF_FUNCTION_STACK_OVERFLOW=-42;

var
  Form1 : TForm1;
  MyServerApp:ICioinaEval;
implementation

{$R *.dfm}
{---------------------------------------------------------}
procedure TForm1.ExecuteErrorMesssage(Item: Integer);
var s,s1:string;
    i   :Integer;
begin
  i:=Pos(':',MyServerApp.ErrorMessageInfo[Item]);
  if i>0 then  s1:=' : '+Copy(MyServerApp.ErrorMessageInfo[Item],i+1,Length(MyServerApp.ErrorMessageInfo[Item])-i) else s1:='';
  if Length(s1)>256 then s1:=Copy(s1,1,256);
  s1:=LowerCase(s1);
  
  s:='';
  case MyServerApp.MathException[Item] of
   EX_NONMATH:s:=' : NONMATH';
   EX_Overflow:s:=' : Overflow';
   EX_Underflow:s:=' : Underflow';
   EX_InvalidArgument:s:=' : InvalidArgument';
   EX_ZeroDivide:s:=' : ZeroDivide';
   EX_InvalidOp:s:=' : InvalidOp';
  end;

  case MyServerApp.ErrorNumber[Item] of
   ERR_NO_MATH_EXPRESSION_WAS_PARSED:           Memo1.Lines.Add('No math expression was parsed');
   ERR_VARIABLES_AND_VALUES_ARE_DIFFERENT:      Memo1.Lines.Add('Variable count and value caunt do not corespond');
   ERR_MATH_EXPRESSIONS_ARRAY:                  Memo1.Lines.Add('Use ''DoVectorOfMathExpressions'' for calculate a vector of math expression');
   ERR_EXECUTE:                                 Memo1.Lines.Add('Execution error');
   ERR_DEF_FUNCTION_STACK_OVERFLOW:             Memo1.Lines.Add('Stack overflow'+s1);
   ERR_SYSTEM_STACK_OVERFLOW:                   Memo1.Lines.Add('Fatal error'+s1);
   ERR_MULTIPLY:                                Memo1.Lines.Add('Invalid value for *'+s1+s);
   ERR_DIVISION:                                if MyServerApp.MathException[Item]=EX_ZeroDivide
                                                then Memo1.Lines.Add('Division by 0 ')
                                                else Memo1.Lines.Add('Invalid value for /'+s1+s);
   ERR_PLUS:                                    Memo1.Lines.Add('Invalid value for +'+s1+s);
   ERR_MINUS:                                   Memo1.Lines.Add('Invalid value for -'+s1+s);
   ERR_POWER:                                   Memo1.Lines.Add('Invalid value for ^'+s1+s);
   ERR_EQUAL:                                   Memo1.Lines.Add('Invalid value for ='+s1+s);
   else
   if (MyServerApp.ErrorNumber[Item]>=1)and(MyServerApp.ErrorNumber[Item]<=MyServerApp.BuiltInFunctionCount)
   then
    if s=''
    then Memo1.Lines.Add('Invalid number of function arguments for: '+ UpperCase(MyServerApp.BuiltInFunctionName[MyServerApp.ErrorNumber[Item]]))
    else Memo1.Lines.Add('Invalid value for '+ UpperCase(MyServerApp.BuiltInFunctionName[MyServerApp.ErrorNumber[Item]])+s1+s)
   else Memo1.Lines.Add(MyServerApp.ErrorMessageInfo[Item]);
  end;
end;

procedure TForm1.ParseErrorMesssage(Item: Integer);
var s,s1:string;
    i:Integer;
begin
  i:=Pos(':',MyServerApp.ErrorMessageInfo[Item]);
  if i>0 then  s1:=' : '+Copy(MyServerApp.ErrorMessageInfo[Item],i+1,Length(MyServerApp.ErrorMessageInfo[Item])-i) else s1:='';
  if Length(s1)>256 then s1:=Copy(s1,1,256);
  s1:=LowerCase(s1);
  s:='';
  case MyServerApp.MathException[Item] of
   EX_NONMATH:s:=' : NONMATH';
   EX_Overflow:s:=' : Overflow';
   EX_Underflow:s:=' : Underflow';
   EX_InvalidArgument:s:=' : InvalidArgument';
   EX_ZeroDivide:s:=' : ZeroDivide';
   EX_InvalidOp:s:=' : InvalidOp';
  end;

  case MyServerApp.ErrorNumber[Item] of
   ERR_PARSE:                                   Memo1.Lines.Add('Invalid expression'+s1);
   ERR_BAD_SYNTAX:                              Memo1.Lines.Add('Syntax error'+s1);
   ERR_COMMA_SYNTAX:                            Memo1.Lines.Add('Comma syntax error'+s1);
   ERR_NO_MATH_EXPRESSION_WAS_PARSED:           Memo1.Lines.Add('No math expression was parsed');
   ERR_PARANTHESES_SYNTAX_ERROR:                Memo1.Lines.Add('Mismatched parenthesis');
   ERR_INVALID_DERIVATIVE_VARIABLE_NAME:        Memo1.Lines.Add('Invalid name of derivative variable'+s1);
   ERR_MATH_EXPRESSION_IS_EMPTY:                Memo1.Lines.Add('Mathematical expression is empty');
   ERR_IDENTIFIER_CANNOT_BE_EMPTY:              Memo1.Lines.Add('Identifier cannot be empty');
   ERR_IDENTIFIER_LENGTH:                       Memo1.Lines.Add('Identifier length is too long'+s1);
   ERR_NOT_PASCAL_IDENTIFIER:                   Memo1.Lines.Add('Invalid identifier'+s1);
   ERR_IDENTIFIER_CANNOT_BE_RESERVED_NAME:      Memo1.Lines.Add('Identifier cannot be a reserved name'+s1);
   ERR_IDENTIFIER_ALREADY_EXISTS:               Memo1.Lines.Add('Identifier already exists'+s1);
   ERR_DUBLICATING_USER_IDENTIFIER:             Memo1.Lines.Add('Dublicating user identifier'+s1);
   ERR_UNKNOWN_EXPRESSION:                      Memo1.Lines.Add('Unknown expression'+s1);
   ERR_UNKNOWN_FUNCTION:                        Memo1.Lines.Add('Undefined function'+s1);
   ERR_UNKNOWN_VARIABLE:                        Memo1.Lines.Add('Undefined variable'+s1);
   ERR_BAD_EXPONENTIAL_FORMAT:                  Memo1.Lines.Add('Invalid exponent value'+s1);
   ERR_SET_OriginalMathExpressionString_FALSE:  Memo1.Lines.Add('Set ''OriginalMathExpressionString'' to FALSE for differentiation or for Mathematica 4.1 export');
   ERR_MATH_EXPRESSION_WAS_ERASED:              Memo1.Lines.Add('Mathematical expression string was erased');
   ERR_USE_VerifySyntaxSemanticsAndDerivation:  Memo1.Lines.Add('Use ''VerifySyntaxSemanticsAndDerivation'' for differentiation');
   ERR_DERIVATIVE_EXPRESSION_WAS_ERASED:        Memo1.Lines.Add('Derivative expression string was erased');
   ERR_VARIABLES_AND_VALUES_ARE_DIFFERENT:      Memo1.Lines.Add('Variable count and value caunt do not corespond');
   ERR_MATH_EXPRESSIONS_ARRAY:                  Memo1.Lines.Add('Use ''DoVectorOfMathExpressions'' for calculate a vector of math expression');
   ERR_FUNCTION_NUMBER_MUST_BE_LESS:            Memo1.Lines.Add('Function number must be less'+s1);
   ERR_FUNCTION_ADDRESS_CANNOT_BE_NIL:          Memo1.Lines.Add('Function address cannot be nil'+s1);
   ERR_PROTECTED_EXPRESSION:                    Memo1.Lines.Add('Cannot set value for protected expression'+s1);
   ERR_DEF_FUNC_NAME:                           Memo1.Lines.Add('Invalid function name'+s1);
   ERR_DEF_FUNC_DUBLICATING:                    Memo1.Lines.Add('Dublicating defined function'+s1);
   ERR_DEF_FUNC_IMPLEMENTING:                   Memo1.Lines.Add('Defined function was not implimented'+s1);
   ERR_DEF_FUNC_ARG_COUNT:                      Memo1.Lines.Add('Invalid arguments number for defined function'+s1);
   ERR_DEF_FUNC_ARG_NAME:                       Memo1.Lines.Add('Invalid argument name for defined function'+s1);
   ERR_DEF_FUNC_ARG_DUBLICATING:                Memo1.Lines.Add('Dublicating argument name for defined function'+s1);
   ERR_MULTIPLY:                                Memo1.Lines.Add('Invalid value for *'+s1+s);
   ERR_DIVISION:                                if MyServerApp.MathException[Item]=EX_ZeroDivide
                                                then Memo1.Lines.Add('Division by 0')
                                                else Memo1.Lines.Add('Invalid value for /'+s1+s);
   ERR_PLUS:                                    Memo1.Lines.Add('Invalid value for +'+s1+s);
   ERR_MINUS:                                   Memo1.Lines.Add('Invalid value for -'+s1+s);
   ERR_POWER:                                   Memo1.Lines.Add('Invalid value for ^'+s1+s);
   ERR_EQUAL:                                   Memo1.Lines.Add('Invalid value for ='+s1+s);
   else
   if (MyServerApp.ErrorNumber[Item]>=1)and(MyServerApp.ErrorNumber[Item]<=MyServerApp.BuiltInFunctionCount)
   then
    if s=''
    then Memo1.Lines.Add('Invalid number of function arguments for: '+ UpperCase(MyServerApp.BuiltInFunctionName[MyServerApp.ErrorNumber[Item]]))
    else Memo1.Lines.Add('Invalid value for '+ UpperCase(MyServerApp.BuiltInFunctionName[MyServerApp.ErrorNumber[Item]])+s1+s)
   else Memo1.Lines.Add(MyServerApp.ErrorMessageInfo[Item]);
  end;
end;
procedure TForm1.FormCreate(Sender: TObject);
begin
 DecimalSeparator:='.';
 MyServerApp := CoCioinaEvalCom.Create();
 MyServerApp.CreateList;
 MyServerApp.AddMathExpression;
 MyServerApp.AddMathExpression;
 MyServerApp.AddSharedVar('x',1,false);
 MyServerApp.AddSharedVar('y',2,false);
 Caption:=MyServerApp.VersionInfo+'    '+MyServerApp.OwnerInfo;
 Edit1Change(Self);
 Edit2Change(Self);
 Edit3Change(Self);
end;

procedure TForm1.Edit1Change(Sender: TObject);
begin
  Memo1.Text:='';
  MyServerApp.Parse(0,Edit1.Text,'',true);
  if MyServerApp.ErrorFlag[0]
  then
  begin
   MyServerApp.SharedVar[0]:=nan;
   Label5.Caption:=FloatToStr(MyServerApp.SharedVar[0]);
   Label1.Caption:='Result';
   ParseErrorMesssage(0);
  end
  else
  begin
   MyServerApp.SharedVar[0]:=MyServerApp.DoMathExpression(0);
   Label5.Caption:=FloatToStr(MyServerApp.SharedVar[0]);
   if MyServerApp.ErrorFlag[0]  then ExecuteErrorMesssage(0);
   Label1.Caption:='Result = '+FloatTostr(MyServerApp.DoMathExpression(1));
   if MyServerApp.ErrorFlag[1]  then ExecuteErrorMesssage(1);
  end;
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
  Memo1.Text:='';
  MyServerApp.Parse(0,Edit2.Text,'',true);
  if MyServerApp.ErrorFlag[0]
  then
  begin
   MyServerApp.SharedVar[1]:=nan;
   Label6.Caption:=FloatToStr(MyServerApp.SharedVar[1]);
   Label1.Caption:='Result';
   ParseErrorMesssage(0);
  end
  else
  begin
   MyServerApp.SharedVar[1]:=MyServerApp.DoMathExpression(0);
   Label6.Caption:=FloatToStr(MyServerApp.SharedVar[1]);
   if MyServerApp.ErrorFlag[0]  then ExecuteErrorMesssage(0);
   Label1.Caption:='Result = '+FloatTostr(MyServerApp.DoMathExpression(1));
   if MyServerApp.ErrorFlag[1]  then ExecuteErrorMesssage(1);
  end;
end;

procedure TForm1.Edit3Change(Sender: TObject);
begin
 Label7.Caption:='Math Expression :';
 Label1.Caption:='Result';
 Memo1.Text:='';
 MyServerApp.ParseWithSharedVar(1,Edit3.Text,true);
 if not(MyServerApp.ErrorFlag[1])
 then
 begin
  Label7.Caption:='Math Expression : OK';
  Label1.Caption:='Result = '+FloatTostr(MyServerApp.DoMathExpression(1));
  if MyServerApp.ErrorFlag[1] then ExecuteErrorMesssage(1);
 end
 else ParseErrorMesssage(1);
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
 if CheckBox1.Checked
 then
 begin
  CheckBox1.Caption:='Space like multiply operator (true)';
  MyServerApp.SpaceLikeMultiply[0]:=true;
  MyServerApp.SpaceLikeMultiply[1]:=true;
  Edit1Change(Self);
  Edit2Change(Self);
  Edit3Change(Self);
 end
 else
 begin
  CheckBox1.Caption:='Space like multiply operator (false)';
  MyServerApp.SpaceLikeMultiply[0]:=false;
  MyServerApp.SpaceLikeMultiply[1]:=false;
  Edit1Change(Self);
  Edit2Change(Self);
  Edit3Change(Self);
 end;
end;

procedure TForm1.Edit1Click(Sender: TObject);
begin
 Edit1Change(Self);
end;

procedure TForm1.Edit2Click(Sender: TObject);
begin
 Edit2Change(Self);
end;

procedure TForm1.Edit3Click(Sender: TObject);
begin
 Edit3Change(Self);
end;

end.
